﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Threading

Public Class MainForm

    '用于跟踪哪个线程调用 UI 更新函数。
    Private callingThread As Integer

    '初始化窗体。
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        '更新 UI 以显示 UI 正在其中运行的当前线程。
        callingThread = System.Threading.Thread.CurrentThread.ManagedThreadId()
        Label2.Text = "The UI Thread Number is: " + callingThread.ToString()
        Label1.Text = ""
    End Sub

    '用于在新线程中更新 UI 的函数。
#Region "新线程函数"

    Private Sub ThreadButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ThreadButton.Click
        '启动一个从中调用 UpdateUI 的新线程。
        Dim newThread As New Thread(AddressOf UpdateUI)
        newThread.Start()
    End Sub

#End Region

    '使用 UI 线程来更新 UI 的函数。
#Region "UI 更新函数"

    Private Sub UIButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UIButton.Click
        '在 UI 线程中更新 UI。
        callingThread = System.Threading.Thread.CurrentThread.ManagedThreadId()
        UpdateUI()
    End Sub

    '由控件调用的委托，该控件在需要更新的窗体上。
    Delegate Sub UIDelegate()

    Private Sub UpdateUI()
        '如果 InvokeRequired 为 true，则在
        'UI 线程以外的线程上进行调用。
        If Label1.InvokeRequired Then
            '使用 UI 控件调用委托，从而调用 UpdateUI
            callingThread = System.Threading.Thread.CurrentThread.ManagedThreadId()
            Dim newDelegate As New UIDelegate(AddressOf UpdateUI)
            Label1.Invoke(newDelegate)
        Else
            Label1.Text = "The update function used thread " + callingThread.ToString()
        End If
    End Sub

#End Region

    '使用线程处理计时器来更新 UI 的函数。
#Region "计时器函数"
    Private Sub StartTimer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles StartTimer.Click

        Dim timerThread As New Thread(AddressOf RunTimer)
        timerThread.Start()

    End Sub

    Class TimerObjClass
        Public Count As Integer
        Public TimerReference As System.Threading.Timer
        Public TimerCanceled As Boolean
    End Class

    Sub RunTimer()
        Dim StateObj As New TimerObjClass()
        StateObj.TimerCanceled = False
        StateObj.Count = 1
        Dim TimerDelegate As New Threading.TimerCallback(AddressOf TimerTask)

        Dim TimerItem As New System.Threading.Timer(TimerDelegate, StateObj, _
                                                    2000, 2000)
        StateObj.TimerReference = TimerItem
        While StateObj.Count < 5
            System.Threading.Thread.Sleep(2000)
        End While

        StateObj.TimerCanceled = True
    End Sub

    Sub TimerTask(ByVal StateObj As Object)
        Dim State As TimerObjClass = CType(StateObj, TimerObjClass)
        State.Count += 1
        callingThread = System.Threading.Thread.CurrentThread.ManagedThreadId()

        UpdateUI()

        If State.TimerCanceled Then
            State.TimerReference.Dispose()
        End If
    End Sub
#End Region

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
